#  Giapetto’s Woodcarving problem
#    from Introduction to Mathematical Programming
#    by Winston and Venkataramanan, 4th edition
#    page 49
# Anything that comes after a ’#’ is a comment
/* C-style comments are also allowed */
# Spacing is generally not important.
# Sets and Parameters
########################
# First we would declare any sets and parameters.   We’re not using
# either of those in this simple example, though.
# Variables
############
# Next we declare our decision variables. It’s best to use
# descriptive names.
# We can also specify nonnegativity here (if appropriate).
var soldiers >= 0;   # Number of soldiers each week
var trains >= 0;    # Number of trains each week
# Objective
############
# The objective needs a name, in this case ’profit’
maximize  profit: 3*soldiers + 2*trains;
# Constraints
##############
# Each constraint needs a name.
s.t. carpentry: soldiers + trains <= 80;
s.t. finishing: 2*soldiers + trains <= 100;
s.t. soldier_demand: soldiers <= 40;
# Remember that we already took care of nonnegativity.
# End
######
# We end the file with an ’end;’ statement
end;

