/*
 * SimplexExample.java contains the SimplexExample class, which is a simple demo
 * application of the simplex method.
 */

package org.nm.challenge.optimization;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.math.optimization.GoalType;
import org.apache.commons.math.optimization.RealPointValuePair;
import org.apache.commons.math.optimization.linear.LinearConstraint;
import org.apache.commons.math.optimization.linear.LinearObjectiveFunction;
import org.apache.commons.math.optimization.linear.Relationship;
import org.apache.commons.math.optimization.linear.SimplexSolver;

/**
 * <p>SimpleExample demonstrates a solution to a simple linear program (LP),
 * using the optimization package of the Apache Commons Math library. The
 * example is taken from <a
 * href="http://www.teachnet.ie/jcleary/example.html">Example of Linear
 * Programming including Maximising and Minimising</a>,
 * which is the copyrighted intellectual property of <a
 * href="http://www.teachnet.ie">TeachNet Ireland</a>. For more information, see
 * the referenced site.</p>
 *
 * <p>In standard form, the example LP is given as:</p>
 *
 * <p>Maximize 100<i>p</i> + 80<i>q</i><br />
 * Subject to:<br />
 * &nbsp;&nbsp;&nbsp;&nbsp;2<i>p</i> + 4<i>q</i> &le; 1600<br />
 * &nbsp;&nbsp;&nbsp;&nbsp;9<i>p</i> + 6<i>q</i> &le; 3600<br />
 * &nbsp;&nbsp;&nbsp;&nbsp;<i>p</i>, <i>q</i> &ge; 0</p>
 *
 * @author Nicholas Bennett
 */
public class SimplexExample {

    /** Objective function coefficients */
    public static final double[] OBJECTIVE_COEFFICIENTS = new double[] {100, 80};
    /** Volume constraint coefficients */
    public static final double[] VOLUME_COEFFICIENTS = new double[] {2, 4};
    /** Volume constraint limit value */
    public static final double VOLUME_LIMIT = 1600;
    /** Mass constraint coefficients */
    public static final double[] MASS_COEFFICIENTS = new double[] {9, 6};
    /** Mass constraint limit value */
    public static final double MASS_LIMIT = 3600;
    /** Optimization output format string */
    public static final String OUTPUT_PATTERN = "Profit on %s of [P, Q] = %f\n";

    /**
     * Uses the simplex method to solve the example LP.
     *
     * @param args command line arguments
     */
    public static void main(String[] args) {
        try {
            // Declare variables for the constraint set, solver, and solution.
            RealPointValuePair solution;
            SimplexSolver solver = new SimplexSolver();
            ArrayList<LinearConstraint> constraints =
                    new ArrayList<LinearConstraint>();
            LinearConstraint volumeConstraint = null;
            LinearConstraint massConstraint = null;

            // Define the objective function, with no added constant value.
            LinearObjectiveFunction objective = 
                    new LinearObjectiveFunction(OBJECTIVE_COEFFICIENTS, 0);

            /*
             * WRITE THE CODE FOR THE CONSTRAINTS: Assign LinearConstraint
             * values to volumeConstraint and massConstraint, using the
             * coefficients and limit values declared above. The constructor for
             * the LinearConstraint class takes three parameters: an array of
             * double coefficient values, a relationship (in this case, both
             * constraints will use Relationship.LEQ), and the constraint limit
             * value (i.e. the right-hand side of the inequality).
             *
             * When finished, these lines of code will look something like this,
             * with the ellipses replaced by meaningful values:
             *
             *     volumeConstraint = new LinearConstraint(...);
             *     massConstraint = new LinearConstraint(...);
             */



            // Add the constraints to the set of active constraints.
            constraints.add(volumeConstraint);
            constraints.add(massConstraint);

            // Solve the LP.
            solution = solver.optimize(
                    objective, constraints, GoalType.MAXIMIZE, true);

            // Print the results to standard output.
            System.out.printf(OUTPUT_PATTERN,
                    Arrays.toString(solution.getPoint()), solution.getValue());
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

}
