/*
 * Cubic line search
 * Purpose:  Find minimum of f in the direction supplied by polriv
 * Date: Oct 10, 2012 
 * Author: Thomas Robey
 * Subroutine
 *   fandg
 */
#include "stdio.h"
#include "math.h"
cubsrch(n,x,f,g,d,awolfe,bwolfe,acclim,alpha,dtg,mxiter,iter)
double *x,*f,*g,*d,dtg,awolfe,bwolfe,acclim,*alpha;
int mxiter,*iter,n;
{
  double ap,fap,f0,dap,xc[2],yc[2],step,phi,dal,temp,mu1,mu2,an,t1,t2,nlfn;
  int i,k;
  char string[5];
  double fandg(double *,double *);
  ap=0.0;
  fap=*f;
  f0=*f;
  dap=dtg;
  step=0.0;
  for (i=0;i<n;i++) {
    step+=*(g+i)**(g+i);
    xc[i]=*(x+i);
    yc[i]=*(g+i);
  }
  k=0;
  while (1) {
    if (step**alpha<acclim && k>1)
      return(-2);
    for (i=0;i<n;i++)
      *(x+i)=*(xc+i)+*alpha**(d+i);
    nlfn=fandg(x,g);
    *f=nlfn;
    *iter+=1;
    if (k>mxiter)
      return(-3);
    phi=0.0;
    for (i=0;i<n;i++)
      phi+=*(d+i)**(g+i);
    dal=phi;
    if (*f<=f0 || dal>=0.0) {
      if (dap==0.0) {
        return(0);
      }
      temp=(dal/dap<0.0) ? -dal/dap : dal/dap;
      if (*f<f0+awolfe**alpha*dtg && temp<bwolfe && k>0) {
        return(0);
      }
      t1=(ap<*alpha) ? ap : *alpha;
      t2=(ap<*alpha) ? *alpha : ap;
      mu1=dap+dal-3.0*(fap-*f)/(ap-*alpha);
      mu2=mu1*mu1-dap*dal;
      if (mu2<0.0)
        an=0.5*t1;
      else {
        mu2=sqrt(mu2);
        an=*alpha-(*alpha-ap)*(dal+mu2-mu1)/(dal-dap+2.0*mu2);
      }
      if (dal/dap>0.0) {
        if (dal>0.0 && (an<=0.0 || an>=0.99*t1))
          an=0.5*t1;
        if (dal<0.0 && an<=1.01*t2)
          an=2.0*t2;
      }
      else {
        if (an<1.01*t1 || an>0.99*t2)
          an=(*alpha+ap)*0.5;
      }
      ap=*alpha;
      fap=*f;
      dap=dal;
      *alpha=an;
    }
    else {
      *alpha/=2.0;
      ap=0.0;
      fap=f0;
      dap=dtg;
    }
    k++;
  }
}                             


